/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:25:51 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.symreg;

import gpsys.*;
import java.util.Random;

/**
 * The GPParameters class for the symbolic regression problem.  Any instance of
 * this class has all the GP parameters correctly set.
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:25:51 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class SymRegGPParameters extends GPParameters {

    /**
     * Constructs a GPParameters object for the symbolic regression problem.
     *
     * @param seed          The seed to be used for the random number generator.
     *                      If a seed value of 0 is supplied, a unique seed is
     *                      generated using the current time.
     * @param population    The size of the population to be used.
     * @param generations   The maximum number of generations to be evolved.
     */
    SymRegGPParameters(long seed, int population, int generations ) {

        this.populationSize     = population;
        this.generations        = generations;

        // create a seed using the current time if the seed suppied is 0
        if (seed == 0)
            rngSeed = System.currentTimeMillis();
        else
            rngSeed = seed;

        rng = new Random(rngSeed);

        pMutation       = 0.05;
        tournamentSize  = 7;

        adf = new ChromosomeParameters[1];
        adf[0] = new SymRegChromosomeParametersADF0(rng);
        fitness = new SymRegFitness();

        this.engine = ENGINE_GENERATIONAL;
    }
}
