/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:25:51 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.symreg;

import java.util.Random;
import gpsys.*;
import gpsys.primitives.*;

/**
 * The Chromosome parameters for ADF0 (the result producing branch) of the
 * symbolic regression problem.  Note that the function set contains If,
 * GE and LE functions which are not really needed, but are included to
 * demonstrate the type system.
 *
 * ADF0 has the following Function and Terminal sets.
 *
 * <pre>
 *      Functions = {Add, Sub, Div, Mult, If, GE, LE}
 *      Terminals = {X, 1}
 * </pre>
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:25:51 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class SymRegChromosomeParametersADF0 extends ChromosomeParameters {

    /**
     * Create the ChromosomeParameters object for ADF0.
     */
    public SymRegChromosomeParametersADF0(Random rng) {

        maxDepth            = 9;
        maxDepthAtCreation  = 7;
        maxDepthMutation    = 3;

        // the return type of the Chromosome when it is evaluated
        type = Type.FLOAT;

        // the types used by this chromosome
        types = new Type[2];
        types[0] = Type.FLOAT;
        types[1] = Type.BOOLEAN;

        //define the function set
        functions = new Function[7];
        // note how the generic functions are being type instantiated
        functions[0] = new Add(Type.FLOAT);
        functions[1] = new Sub(Type.FLOAT);
        functions[2] = new Mul(Type.FLOAT);
        functions[3] = new Div(Type.FLOAT);
        functions[4] = new If(Type.FLOAT);
        functions[5] = new GE(Type.FLOAT);
        functions[6] = new LT(Type.FLOAT);

        // define the terminal set
        terminals = new Terminal[2];
        terminals[0] = new XFloat();
        // note how this generic terminal is being type instantiated
        terminals[1] = new One(Type.FLOAT);

        createMethod = CREATE_RAMP_HALF_AND_HALF;
    }
}
