/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:24:33 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.primitives;

import gpsys.*;
import java.util.Random;

/**
 * <pre>
 *  &lt;typeX&gt; Zero
 * </pre>
 *
 * Zero is a generic Terminal which which represents the constant value zero.
 * Zero needs to be instantiated to return values for a particular type.
 * Valid types include BYTE, SHORT, INT, LONG, FLOAT and DOUBLE.
 *
 * @see         gpsys.Type
 * @see         gpsys.Primitive
 * @see         gpsys.Terminal
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:24:33 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class Zero extends Terminal {

    /**
     * Constructs a constant of value zero for the specified type.
     *
     * @param type  The required type of the Zero's value.
     */
    public Zero(Type type) {
        this.type = type;
    }
        
    /**
    * Used to get a BYTE value of the constant zero.
    *
    * @param i          The individual being evaluated.
    * @return A byte representing the value of the constant zero.
    * @exception    EvaluationException If there is an evaluation failure.
    */
    public final byte evaluateByte(Individual i)
    throws EvaluationException {
        return 0;
    }

    /**
    * Used to get a SHORT value of the constant zero.
    *
    * @param i          The individual being evaluated.
    * @return A short representing the value of the constant zero.
    * @exception    EvaluationException If there is an evaluation failure.
    */
    public final short evaluateShort(Individual i)
    throws EvaluationException {
        return 0;
    }

    /**
    * Used to get a INT value of the constant zero.
    *
    * @param i          The individual being evaluated.
    * @return An int representing the value of the constant zero.
    * @exception    EvaluationException If there is an evaluation failure.
    */
    public final int evaluateInt(Individual i)
    throws EvaluationException {
        return 0;
    }

    /**
    * Used to get a LONG value of the constant zero.
    *
    * @param i          The individual being evaluated.
    * @return A long representing the value of the constant zero.
    * @exception    EvaluationException If there is an evaluation failure.
    */
    public final long evaluateLong(Individual i)
    throws EvaluationException  {
        return 0;
    }

    /**
    * Used to get a FLOAT value of the constant zero.
    *
    * @param i          The individual being evaluated.
    * @return A float representing the value of the constant zero.
    * @exception    EvaluationException If there is an evaluation failure.
    */
    public final float evaluateFloat(Individual i)
    throws EvaluationException {
        return 0.0f;
    }

    /**
    * Used to get a DOUBLE value of the constant zero.
    *
    * @param i          The individual being evaluated.
    * @return A double representing the value of the constant zero.
    * @exception    EvaluationException If there is an evaluation failure.
    */
    public final double evaluateDouble(Individual i)
    throws EvaluationException {
        return 0.0;
    }

    /**
    * Creates an instance of this Zero object.  The Type instantiation is
    * preserved so that if an INT Zero is being cloned, the clone will also be
    * INT instantiated.
    *
    * @return   A reference to this Object (yes the same object, since
    *           the type information is to be the same, there are therefore
    *           no instance variables to be modified.
    */
    public final Primitive instance() {
        return this;
    }

    /**
    * Returns a String representation of this Terminal.
    *
    * @return A String containing the name of the Terminal.
    */
    public String toString() {
        return "" + 0;
    }
}
