/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:24:33 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.primitives;

import gpsys.*;

/**
 * <pre>
 *  DOUBLE XDouble
 * </pre>
 *
 * XDouble is a Terminal representing a variable of Type DOUBLE.
 *
 * @see         gpsys.Type
 * @see         gpsys.Primitive
 * @see         gpsys.Terminal
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:24:33 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class XDouble extends Terminal {
    /**
     * Holds the value of the variable.
     */
    double dvalue;

    /**
     * Construct a new variable.
     */
    public XDouble() {
        this.type = Type.DOUBLE;
    }

    /**
     * Evaluates the variable, which returns its value.
     *
     * @param   i   The variable being evaluated.
     * @return  A double which is the value of the variable.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public final double evaluateDouble(Individual i)
    throws EvaluationException {
        return dvalue;
    }

    /**
     * Sets the variable to the specified value.
     *
     * @param value The value to be assigned to the variable.
     */
    public final void set(double value) {
        dvalue = value;
    }

    /**
     * Creates a copy of this Terminal.
     *
     * @return  Actaully a reference to the same Terminal since there is no
     *          change in instance variables required.
     */
    public final Primitive instance() {
        return this;
    }

    /**
     * Creates a String representing this Terminal.
     *
     * @return A String containing the name of this Terminal.
     */
    public String toString() {
        return "XDouble";
    }
}
