/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:24:33 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.primitives;

import gpsys.*;

/**
 * <pre>
 *  BOOLEAN True
 * </pre>
 *
 * True is a Terminal of Type BOOLEAN.  It represents the boolean value
 * true.
 *
 * @see         gpsys.Type
 * @see         gpsys.Primitive
 * @see         gpsys.Terminal
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:24:33 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class True extends Terminal {

    /**
     * Constructs a new True object.
     */
    public True() {
        type = Type.BOOLEAN;
    }
        
    /**
     * Evaluates the True Terminal.  The evaluation always returns the value
     * true.
     *
     * @param i The Individual being evaluated.
     * @return  The value true.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public final boolean evaluateBoolean(Individual i)
    throws EvaluationException {
        return true;
    }

    /**
     * Creates a copy of this Terminal.
     *
     * @return  Actaully a reference to the same Terminal since there is no
     *          change in instance variables required.
     */
    public final Primitive instance() {
        return this;
    }

    /**
     * Creates a String representing this Terminal.
     *
     * @return A String containing the name of this Terminal.
     */
    public String toString() {
        return "" + true;
    }
}
