/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:24:33 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.primitives;

import gpsys.*;


/**
 * <pre>
 *  BOOLEAN not(BOOLEAN value)
 * </pre>
 *
 * Not is a boolean function that returns the logical "negation" of its one
 * argument.
 *
 * @see         gpsys.Type
 * @see         gpsys.Primitive
 * @see         gpsys.Function
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:24:33 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class Not extends Function {

    /**
    * Construct an instance of the Not Function.  The Not Function is of
    * BOOLEAN Type and is hence typed accordingly.
    */
    public Not() {
        type = Type.BOOLEAN;
        argTypes = new Type[1];
        argTypes[0] = type;
    }

    /**
    * Perform the logical Not of the one argument and return the result.
    *
    * @param i  The individual being evaluated.
    * @param arguments  The Gene tree representing the argument to be Noted.
    * @return A boolean representing the logical Not of the argument.
    * @exception    EvaluationException If there is an evaluation failure.
    */
    public final boolean evaluateBoolean(Individual i, Gene[] arguments)
    throws EvaluationException {
        return ! arguments[0].evaluateBoolean(i);
    }

    /**
    * Creates an instance of this And Function.
    *
    * @return A reference to this object.
    */
    public final Primitive instance() {
        return this;
    }

    /**
    * Returns a String representation of this Function.
    *
    * @return A String containing the name of the Function.
    */
    public String toString() {
        return "Not";
    }
}
