/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:24:33 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.primitives;

import gpsys.*;

/**
 * <pre>
 *  MEM_INT MemInt
 * </pre>
 *
 * MemInt is a Terminal that implements indexed memory of INT type.
 * The primitives MemGet and MemSet must be used to get and set any of the
 * locations of the memory.
 *
 * @see         gpsys.Type
 * @see         gpsys.Primitive
 * @see         gpsys.Terminal
 * @see         gpsys.MemGet
 * @see         gpsys.MemSet
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:24:33 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class MemInt extends Terminal {
    /**
     * The array used to implement the memory.
     */
    int[] memory;

    /**
     * Construct indexed memory of the specified size.
     *
     * @param size  The number memory locations needed.
     */
    public MemInt(int size) {
        type = Type.MEM_INT;
        memory = new int[size];
    }

    /**
     * Evaluation of indexed memory just returns a reference to the memory.
     * This reference can then be used as a parameter to MemGet or MemSet.
     *
     * @param i The individual being evaluated.
     * @return A reference to this indexed memory object.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public final Object evaluateObject(Individual i)
    throws EvaluationException {
        return this;
    }

    /**
     * Sets the specified memory location to the default value (0).
     *
     * @param index The index of the memory location to be reset.
     */
    public final void reset(int index) {
        for (int i = 0; i < memory.length; i++)
            memory[i] = 0;
    }

    /**
     * Sets the specified memory location to the specified value.
     *
     * @param index The index of the memory location to be set.
     * @param value The value to be assigned to the memory location.
     * @return  The value assigned to the specified memory location, if the
     *          index was valid (within range), and 0 otherwise.
     * 
     */
    public final int set(int index, int value) {
        if ( (index >= memory.length) || (index < 0) )
            return 0;
        return memory[index] = value;
    }

    /**
     * Gets the value of the specified memory location.
     *
     * @param index The index of the memory location to be read.
     * @return  The value of the specified memory location, if the
     *          index was valid (within range), and 0 otherwise.
     * 
     */
    public final int get(int index) {
        if ( (index >= memory.length) || (index < 0) )
            return 0;
        return memory[index];
    }

    /**
     * Creates a copy of this Terminal.
     *
     * @return  Actaully a reference to the same Terminal since there is no
     *          change in instance variables required.
     */
    public final Primitive instance() {
        return this;
    }

    /**
     * Creates a String representing this Terminal.
     *
     * @return A String containing the name of this Terminal.
     */
    public String toString() {
        return "MemInt";
    }
}
