/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:24:33 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.primitives;

import gpsys.*;
import java.util.Random;

/**
 * <pre>
 *  FLOAT ConstantFloat
 * </pre>
 *
 * Creates a Terminal representing an ephemeral random constant of Type
 * FLOAT.
 *
 * @see         gpsys.Type
 * @see         gpsys.Primitive
 * @see         gpsys.Terminal
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:24:33 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class ConstantFloat extends Terminal {
    /**
    * The value of this constant.
    */
    public  float f;
    /**
     * The smallest value that this constant can take.
     */
    private float from;
    /**
     * The largest value that this constant can take.
     */
    private float to;
    /**
     * The random number generator used to create this constant.
     */
    private Random rng;

    /**
    * Create a ephemeral random constant of type float in the range between
    * from and to using the random number generator rng.
    *
    * @param rng    The random number generator to be used.
    * @param from   The smallest value that the constant can take.
    * @param to     The largest value that the constant can take.
    */
    public ConstantFloat(Random rng, float from, float to) {
        this.type = Type.FLOAT;
        this.rng    = rng;
        this.from   = from;
        this.to     = to;
        float size  = to - from;
        f = from + (size * rng.nextFloat());
    }
        
    /**
    * Evaluate this Terminal.
    *
    * @param i  The individual being evaluated.
    * @return   The value of the constant.
    * @exception    EvaluationException If there is an evaluation failure.
    */
    public final float evaluateFloat(Individual i)
    throws EvaluationException {
        return f;
    }

    /**
    * Creates a new FLOAT constant in exactly the same range as this
    * constant, and using the same random number generator.
    *
    * @return A new FLOAT constant in exactly the same range.
    */
    public final Primitive instance() {
        return new ConstantFloat(rng, from, to);
    }

    /**
    * Returns the value of the constant as a String.
    *
    * @return A String representing the value of this constant.
    */
    public String toString() {
        return "" + f;
    }
}
