/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:24:33 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.primitives;

import gpsys.*;
import java.util.Random;

/**
 * <pre>
 *  DOUBLE ConstantDouble
 * </pre>
 *
 * Creates a Terminal representing an ephemeral random constant of Type
 * DOUBLE.
 *
 * @see         gpsys.Type
 * @see         gpsys.Primitive
 * @see         gpsys.Terminal
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:24:33 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class ConstantDouble extends Terminal {
    /**
    * The value of this constant.
    */
    public double d;
    /**
    * The smallest value that this constant can take.
    */
    private double from;
    /**
    * The largest value that this constant can take.
    */
    private double to;
    /**
    * The random number generator used to create this constant.
    */
    private Random rng;

    /**
    * Create a ephemeral random constant of type double in the range between
    * from and to using the random number generator rng.
    *
    * @param rng    The random number generator to be used.
    * @param from   The smallest value that the constant can take.
    * @param to     The largest value that the constant can take.
    */
    public ConstantDouble(Random rng, double from, double to) {
        this.type = Type.DOUBLE;
        this.rng    = rng;
        this.from   = from;
        this.to     = to;
        double size = to - from;
        d = from + (size * rng.nextDouble());
    }
        
    /**
    * Evaluate this Terminal.
    *
    * @param i  The individual being evaluated.
    * @return   The value of the constant.
    * @exception    EvaluationException If there is an evaluation failure.
    */
    public final double evaluateDouble(Individual i)
    throws EvaluationException {
        return d;
    }

    /**
    * Creates a new DOUBLE constant in exactly the same range as this
    * constant, and using the same random number generator.
    *
    * @return A new DOUBLE constant in exactly the same range.
    */
    public final Primitive instance() {
        return new ConstantDouble(rng, from, to);
    }

    /**
    * Returns the value of the constant as a String.
    *
    * @return A String representing the value of this constant.
    */
    public String toString() {
        return "" + d;
    }
}
