/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:26:49 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.lawnmower;

/**
 * The Vector2Mod8 type is a 2 element vector consisting of numbers in the
 * range 0 to 7.  The modulo 8 arithmetic is used to guarantee that the
 * elements stay in this range.
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:26:49 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class Vector2Mod8 implements java.io.Serializable {
    /**
     * The first element of the vector.
     */
    int x;
    /**
     * The second element of the vector.
     */
    int y;

    /**
     * The zero Vector2Mod8 (0,0).
     */
    public static final Vector2Mod8 Zero = new Vector2Mod8(0, 0);

    /**
     * Construct a new Vector2Mod8 object with the elements initialised to
     * the specified values.  Modulo 8 arithmetic is used to ensure that the
     * elements are in the range 0 to 7.
     *
     * @param x The first element of the Vector.
     * @param x The second element of the Vector.
     */
    public Vector2Mod8(int x, int y) {
        this.x = x % 8;
        this.y = y % 8;
    }
        
    /**
     * Construct a new Vector2Mod8 object which is the sum of the specified
     * Vector2Mod8 objects.  Modulo 8 arithmetic is used to ensure that the
     * elements are in the range 0 to 7.
     *
     * @param v1    The first Vector2Mod8 object.
     * @param v2    The second Vector2Mod8 object.
     */
    public static final Vector2Mod8 add(Vector2Mod8 v1, Vector2Mod8 v2) {
        int xnew = (v1.x + v2.x) % 8;
        int ynew = (v1.y + v2.y) % 8;
        return new Vector2Mod8(xnew, ynew);
    }

    /**
     * Creates a String representing this Vector2Mod8 object.
     *
     * @return A String representing this object.
     */
    public String toString() {
        return "(" + x + "," + y + ")";
    }
}
