/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:26:49 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.lawnmower;

import gpsys.*;

/**
 * <pre>
 *  Vector2Mod8 Left
 * </pre>
 * A Terminal that instructs the lawnmower to turn left by 90 degrees.
 *
 * @see         gpsys.Primitive
 * @see         gpsys.Terminal
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:26:49 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class Left extends Terminal {
    /**
     * The lawnmower being controlled.
     */
    private Mower mower;

    /**
     * Create a new Left terminal which controls the specified lawn mower.
     *
     * @param mower The mower to be controlled.
     */
    public Left(Mower mower) {
        this.type = LawnMowerTypes.Vector2Mod8;
        this.mower  = mower;
    }
        
    /**
     * Evaluates this Terminal, causing the mower to turn left by 90 degrees.
     *
     * @param i         The individual being evaluated.
     *
     * @return  An Object (actually a Vector2Mod8) representing the
     *          Zero Vector2Mod8.
     */
    public final Object evaluateObject(Individual i) {
        mower.left();
        return Vector2Mod8.Zero;
    }

    /**
     * Creates a new instance of this Object.
     *
     * @return  A reference to this same Object since none of the instance
     *          variables are to be changed.
     */
    public final Primitive instance() {
        return this;
    }

    /**
     * Returns a String representation of this Terminal.
     *
     * @return A String containing the name of the Terminal.
     */
    public String toString() {
        return "Left";
    }
}
