/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:26:49 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.lawnmower;

import java.awt.*;
import java.io.*;

/**
 * Provides a view of the lawn and lawnmower on the lawn.
 *
 * @see         gpsys.lawnmower.Lawn
 * @see         gpsys.lawnmower.LawnObserver
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:26:49 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class LawnViewer extends Canvas implements LawnObserver {
    /**
     * The lawn being monitored.
     */
    Lawn    lawn;
    /**
     * The current X-coordinate of the lawnmower.
     */
    int mowerX;
    /**
     * The current Y-coordinate of the lawnmower.
     */
    int mowerY;

    /**
     * Create a new LawnViewer Object which provides a view of the specified
     * Lawn.
     *
     * @param lawn  The Lawn being viewed.
     */
    public LawnViewer(Lawn lawn) {
        this.lawn = lawn;
    }

    /**
     * Initialise the position of the mower on the lawn.
     */
    public void init() {
        mowerX = 4;
        mowerY = 4;
    }

    /**
     * Override the Canvas update() method so that the Canvas is not cleared
     * before it is redrawn.
     *
     * @param g The graphics Object associated with the Canvas.
     */
    public void update(Graphics g) {
        paint(g);
    }

    /**
     * Override the Canvas paint() method so that the lawn and lawnmower
     * is drawn on the Canvas.
     *
     * @param g The graphics Object associated with the Canvas.
     */
    public void paint(Graphics g) {
        for (int i = 0; i < lawn.lawn.length; i++)
            for (int j = 0; j < lawn.lawn.length; j++) {
                if (lawn.lawn[i][j] == Lawn.CUT)
                    g.setColor(Color.white);
                else
                    g.setColor(Color.green);
                g.fillRect(i * 50, j * 50, 50, 50);
            }
        g.setColor(Color.black);
        g.fillRect(mowerX * 50, mowerY * 50, 50, 50);
    }

    /**
     * Update the lawn view when the lawn regrows.
     */
    public void lawnGrown() {
        mowerX = 4;
        mowerY = 4;
        repaint();
        try {
            Thread.sleep(500);
        }
        catch (InterruptedException e) {}
    }

    /**
     * Update the lawn view when a square on the lawn is being cut.
     *
     * @param x The X-coordinate of the square being cut.
     * @param y The Y-coordinate of the square being cut.
     */
    public void lawnCutting(int x, int y) {
        mowerX = x;
        mowerY = y;
        repaint();
        try {
            Thread.sleep(500);
        }
        catch (InterruptedException e) {}
    }
}
