/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:26:49 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.lawnmower;

/**
 * Allows monitoirng of changes to the Lawn.
 *
 * @see         gpsys.lawnmower.Lawn
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:26:49 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public interface LawnObserver {
    /** 
     * Called when the entire lawn regrows.
     */
    public void lawnGrown();
    /** 
     * Called when the square at the specified coordinates is being cut.
     *
     * @param x The X-coordinate of the lawn square being cut.
     * @param y The Y-coordinate of the lawn square being cut.
     */
    public void lawnCutting(int x, int y);
}
