/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:26:49 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.lawnmower;

import gpsys.*;
import java.util.Random;

/**
 * The GPParameters class for the lawnmower problem.  Any instance of
 * this class has all the GP parameters correctly set.
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:26:49 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class LawnMowerGPParameters extends GPParameters {
    /**
     * The lawn to be mowed.
     */
    public Lawn     lawn;
    /**
     * The mower to be controlled.
     */
    public Mower    mower;

    /**
     * Constructs a GPParameters object for the lawn mower problem.
     *
     * @param seed          The seed to be used for the random number generator.
     *                      If a seed value of 0 is supplied, a unique seed is
     *                      generated using the current time.
     * @param population    The size of the population to be used.
     * @param generations   The maximum number of generations to be evolved.
     */
    LawnMowerGPParameters(long seed, int population, int generations ) {

        this.populationSize     = population;
        this.generations        = generations;

        if (seed == 0)
            rngSeed = System.currentTimeMillis();
        else
            rngSeed = seed;
        rng = new Random(rngSeed);

        pMutation       = 0.05;
        tournamentSize  = 7;

        lawn    = new Lawn(8);      // create an 8x8 lawn
        mower   = new Mower(lawn);  // create a lawnmower to mow above lawn

        adf = new ChromosomeParameters[3];
        // doesn't matter if we initialise in non-conventional order
        // in this case it is positively helpfull !!
        adf[2] = new LawnMowerChromosomeParametersADF2(mower, rng);
        adf[0] = new LawnMowerChromosomeParametersADF0(mower, rng,
                ((LawnMowerChromosomeParametersADF2) adf[2]).arg0);
        adf[1] = new LawnMowerChromosomeParametersADF1(mower, rng);
        fitness = new LawnMowerFitness(lawn, mower);
    }
}
