/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:26:49 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.lawnmower;

import java.util.Random;
import gpsys.*;
import gpsys.primitives.*;

/**
 * The Chromosome parameters for ADF2 of the lawn mower problem.
 *
 * ADF2 has the following Function and Terminal sets.
 *
 * <pre>
 *      Functions = {AddVector2Mod8, Frog, Prog2}
 *      Terminals = {ADF1, ADF2Arg0, Left, Mow, ConstantVector2Mod8}
 * </pre>
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:26:49 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class LawnMowerChromosomeParametersADF2 extends ChromosomeParameters {
    ADF2Arg0 arg0;

    /**
     * Create the ChromosomeParameters object for ADF2.
     *
     * @param mower The lawnmower to be controlled.
     * @param rng   The random number generator to use.
     */
    public LawnMowerChromosomeParametersADF2(Mower mower, Random rng) {

        maxDepth            = 9;
        maxDepthAtCreation  = 5;
        maxDepthMutation    = 3;

        // the return type of ADF2
        type = LawnMowerTypes.Vector2Mod8;

        // the table of all types use by this ADF
        types = new Type[1];
        types[0] = LawnMowerTypes.Vector2Mod8;

        // the function set
        functions = new Function[3];
        functions[0] = new AddVector2Mod8();
        functions[1] = new Frog(mower);
        functions[2] = new ProgN(type, 2);

        // the terminal set
        terminals = new Terminal[5];
        terminals[0] = new ADF1();
        terminals[1] = arg0 = new ADF2Arg0();
        terminals[2] = new Left(mower);
        terminals[3] = new Mow(mower);
        terminals[4] = new ConstantVector2Mod8(rng);

        createMethod = CREATE_RAMP_HALF_AND_HALF;
    }
}
