/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:26:49 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.lawnmower;

import gpsys.*;


/**
 * <pre>
 *  Vector2Mod8 Frog(Vector2Mod8 displacement)
 * </pre>
 *
 *  The Frog Function allows the lawn mower to leap frog by specified X and Y
 *  displacements on the lawn.  It takes a single Vector2Mod8 argument which
 * represents the displacement and returns the same argument.
 *
 * @see         gpsys.Type
 * @see         gpsys.Primitive
 * @see         gpsys.Terminal
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:26:49 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class Frog extends Function {
    Mower mower;

    /**
     * Create a Frog object that controls the specified lawn mower.
     *
     * @param mower The Mower to move.
     */
    public Frog(Mower mower) {
        this.mower = mower;
        this.type = LawnMowerTypes.Vector2Mod8;
        argTypes = new Type[1];
        argTypes[0] = type;
    }

    /**
     * Evaluates this Function, causing the mower to leap frog by the
     * specified displacement.
     *
     * @param i         The individual being evaluated.
     * @param arguments The Gene tree representing the displacement.
     *
     * @return  An Object (actually a Vector2Mod8) representing the
     *          displacement.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public final Object evaluateObject(Individual i, Gene[] arguments)
    throws EvaluationException {
        return mower.frog((Vector2Mod8) arguments[0].evaluateObject(i));
    }

    /**
     * Creates a new instance of this Object.
     *
     * @return  A reference to this same Object since none of the instance
     *          variables are to be changed.
     */
    public final Primitive instance() {
        return this;
    }

    /**
     * Returns a String representation of this Function.
     *
     * @return A String containing the name of the Function.
     */
    public String toString() {
        return "Frog";
    }
}
