/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:26:49 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.lawnmower;

import gpsys.*;
import java.util.Random;

/**
 * <pre>
 *  Vector2Mod8 ConstantVector2Mod8
 * </pre>
 *
 * Creates a Terminal representing an ephemeral random constant of Type
 * Vector2Mod8.
 *
 * @see         gpsys.Type
 * @see         gpsys.Primitive
 * @see         gpsys.Terminal
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:26:49 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class ConstantVector2Mod8 extends Terminal {
    /**
     * The value of this constant.
     */
    public  Vector2Mod8 v;
    /**
     * The random number generator.
     */
    private Random rng;

    /**
     * Create a new ephemeral random Vector2Mod8 constant in the range
     * (0,0) to (8,8).
     *
     * @param rng   The random number generator to be used.
     */
    public ConstantVector2Mod8(Random rng) {
        this.type = LawnMowerTypes.Vector2Mod8;
        this.rng    = rng;

        int x = rng.nextInt() % 8;
        x = (x < 0) ? -x : x;

        int y = rng.nextInt() % 8;
        y = (y < 0) ? -y : y;

        v = new Vector2Mod8(x,y);
    }
        
    /**
    * Evaluate this Terminal.
    *
    * @param i  The individual being evaluated.
    * @return   The value of the constant.
    */
    public final Object evaluateObject(Individual i) {
        return v;
    }

    /**
    * Creates a new Vector2Mod8 constant in exactly the same range as this
    * constant, and using the same random number generator.
    *
    * @return A new Vector2Mod8 constant in exactly the same range.
    */
    public final Primitive instance() {
        return new ConstantVector2Mod8(rng);
    }

    /**
    * Returns the value of the constant as a String.
    *
    * @return A String representing the value of this constant.
    */
    public String toString() {
        return v.toString();
    }
}
