/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:26:49 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.lawnmower;

import gpsys.*;


/**
 * <pre>
 *  Vector2Mod8 AddVector2Mod8(Vector2Mod8 v1, Vector2Mod8 v2)
 * </pre>
 *
 * A Function that adds two Vector2Mod8 quantities and returns the result.
 *
 * @see gpsys.Primitive
 * @see gpsys.Function
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:26:49 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class AddVector2Mod8 extends Function {

    /**
     * Create a Vector2Mod8 adder object.
     */
    public AddVector2Mod8() {
        this.type = LawnMowerTypes.Vector2Mod8;
        argTypes = new Type[2];
        argTypes[0] = type;
        argTypes[1] = type;
    }

    /**
     * Evaluate the ADF as one that return an Object (this is necessary since
     * the evaluation actually returns a Vector2Mod8 object).
     *
     * @param i The individual being evaluated.
     * @param arguments The Gene trees representing the arguments to be
     *                  added.
     * @return  An Object reference, which is the result of adding the two
     *          Vector2Mod8 arguments.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public final Object evaluateObject(Individual i, Gene[] arguments)
    throws EvaluationException {
        return Vector2Mod8.add(
             (Vector2Mod8) arguments[0].evaluateObject(i),
             (Vector2Mod8) arguments[1].evaluateObject(i));
    }

    /**
     * Creates an instance of this Function.
     *
     * @return  A reference to this same Object since none of the instance
     *          variables will ever be changed. 
     */
    public final Primitive instance() {
        return this;
    }

    /**
     * Returns a String representation of this Function.
     *
     * @return A String containing the name of the Function.
     */
    public String toString() {
        return "AddVector2Mod8";
    }
}
