/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:26:49 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.lawnmower;

import gpsys.*;

/**
 * <pre>
 *  Vector2Mod8 ADF2Arg0
 * </pre>
 *
 * This Terminal represents the one and only argument of ADF2.  It is needed
 * since an argument of an ADF occurrs in the Terminal set of the ADF.
 *
 * @see gpsys.Primitive
 * @see gpsys.Terminal
 * @see gpsys.ADFunction
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:26:49 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class ADF2Arg0 extends Terminal {
    /**
     * The value of the argument.
     */
    Vector2Mod8 value;

    /**
     * Create a new ADF2Arg0 object, setting the type to Vector2Mod8.
     */
    public ADF2Arg0() {
        this.type = LawnMowerTypes.Vector2Mod8;
    }

    /**
     * Set the value of this terminal to the specified value.
     *
     * @param value The value to be assumed by the argument.
     */
    public void set(Vector2Mod8 value) {
        this.value = value;
    }

    /**
     * Evaluates the Terminal as an Object, since a Vector2Mod8 is not one of
     * the java primitive types.
     *
     * @param i The Individual being evaluated.
     */
    public Object evaluateObject(Individual i) {
        return value;
    }

    /**
     * Creates an instance of this Terminal.
     *
     * @return  A reference to this same Object since none of the instance
     *          variables will ever be changed. 
     */
    public Primitive instance() {
        return this;
    }

    /**
     * Returns a String representation of this Terminal.
     *
     * @return A String containing the name of the Terminal.
     */
    public String toString() {
        return "ADF2Arg0";
    }
}
