/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:26:49 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.lawnmower;

import gpsys.*;

/**
 * <pre>
 *  Vector2Mod8 ADF2(Vector2Mod8 arg)
 * </pre>
 *
 * ADF2 is an automatically defined Function which takes one argument.  This is
 * just a wraparound that allows the ADF to be added to the functions set of
 * other ADFs.  The actual body of ADF2 is in Chromosome 2 (adf[2]) of an
 * Individual.  Note that since the argument to ADF2 occurs in the terminal
 * set of ADF2, it must be treated just like a Terminal, and it is hence
 * defined elsewhere as a terminal.
 *
 * @see gpsys.Primitive
 * @see gpsys.Function
 * @see gpsys.ADFunction
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:26:49 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class ADF2 extends ADFunction {
    /**
     * A reference to the Terminal defining the argument to this Function.
     */
    ADF2Arg0 arg0;

    /**
     * Create an ADF2 Object.
     *
     * @param   arg0    A reference to the Terminal defining the argument to
     *                  this Function.
     */
    public ADF2(ADF2Arg0 arg0) {

        adfIndex = 2;   // ADF2 = Chromosome 2 of an Individual = adf[2]
        this.arg0 = arg0;
        this.type = LawnMowerTypes.Vector2Mod8;

        argTypes = new Type[1];
        argTypes[0] = type;
    }

    /**
     * Evaluate the ADF as one that return an Object (this is necessary since
     * the evaluation actually returns a Vector2Mod8 object).  Before the adf is
     * evaluated, the value of the terminal representing the argument to this
     * ADF is set to the result of evaluating the argument branch of this ADF.
     *
     * @param i The individual being evaluated.
     * @param arguments The Gene trees representing the arguments to this
     *                  Function.
     * @return  An Object reference, which is the result of evaluating this
     *          Function.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public Object evaluateObject(Individual i, Gene[] arguments)
    throws EvaluationException {
        // evaluate the argument first since it appears in the Terminal set
        // of the ADF
        arg0.set((Vector2Mod8) arguments[0].evaluateObject(i));
        // now evaluate the ADF itself
        Gene body = i.adf[adfIndex].treeTop;
        return body.evaluateObject(i);
    }

    /**
     * Creates an instance of this ADF.
     *
     * @return  A reference to this same Object since none of the instance
     *          variables will ever be changed. 
     */
    public Primitive instance() {
        return this;
    }

    /**
     * Returns a String representation of this Function.
     *
     * @return A String containing the name of the Function.
     */
    public String toString() {
        return "ADF2";
    }
}
