/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:26:49 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys.lawnmower;

import gpsys.*;

/**
 * <pre>
 *  Vector2Mod8 ADF1
 * </pre>
 *
 * ADF1 is an automatically defined Terminal.  This is just a wraparound that
 * allows the ADF to be added to the terminal set of other ADFs.  The actual
 * body of ADF1 is in Chromosome 1 (adf[1]) of an Individual.
 *
 * @see gpsys.Primitive
 * @see gpsys.Terminal
 * @see gpsys.ADTerminal
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:26:49 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class ADF1 extends ADTerminal {

    /**
     * Construct an ADF1 terminal assigning its type to Vector2Mod8.
     */
    public ADF1() {
        adfIndex = 1;   // index to the chromosome containing the body
        type = LawnMowerTypes.Vector2Mod8;
    }

    /**
     * Evaluate the evolved terminal as primitive that returns an Object
     * reference.
     *
     * @param i The individual containing the evolved body for this ADF
     * @return An Object reference representing the result of the evaluation.
    * @exception    EvaluationException If there is an evaluation failure.
     */
    public Object evaluateObject(Individual i)
    throws EvaluationException {
        Gene body = i.adf[adfIndex].treeTop;
        return body.evaluateObject(i);
    }

    /**
     * Create another instance of this ADTerminal.
     *
     * @return  Since all the instance variable are to be the same, we just
     *          return a reference to the same object.
     */
    public Primitive instance() {
        return this;
    }

    /**
     * Returns a String representation of this ADTerminal.
     *
     * @return A String containing the name of the ADTerminal.
     */
    public String toString() {
        return "ADF1";
    }
}
