/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:21:25 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys;

import java.util.Hashtable;

/**
 * A Table that maps a given Type to an array of Functions returning that type.
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:21:25 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class TypeToFunctionsTable implements java.io.Serializable {
    /**
    * The hash table used to store the Function arrays.  The key used is the
    * return type of the Functions.
    */
    Hashtable theTable;

    /**
    * Creates a table of the specified initial capacity.  The table is
    * automatically increased in size if the number of entries exceed 50% of
    * the initial capacity.
    *
    * @param initialCapacity    The initial capacity of the table.
    */
    public TypeToFunctionsTable(int initialCapacity) {
        theTable = new Hashtable(initialCapacity, 0.5f);
    }

    /**
    * Get all the Functions that return the specified type.
    *
    * @param t  The return type of the Functions.
    */
    public final Function[] get(Type t) {
        return (Function[]) theTable.get(t);
    }

    /**
    * Put the specified Functions array in the table.  The functions all
    * return the type t which is the key to be used for retrieval via get().
    *
    * @param t          The return type of the Functions.
    * @param functions  The array of functions return the above type.
    */
    public final void put(Type t, Function[] functions) {
        theTable.put(t, functions);
    }
}
