/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:21:25 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys;

/**
 * A TypeException is generated when a Gene tree is being generated, and no
 * Function or Terminal of the required type at the given depth can be found.
 *
 * @see gpsys.GPException
 * @see gpsys.GeneFunctionGrow
 * @see gpsys.GeneFunctionFull
 * @see gpsys.GeneTerminal
 * @see gpsys.Chromosome
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:21:25 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class TypeException extends GPException {
    /**
     * Create an TypeException with an empty message.
     */
    public TypeException() {
        super();
    }

    /**
     * Create an TypeException with the specified message.
     *
     * @param   message     a message describing the the exception.
     */
    public TypeException(String message) {
        super(message);
    }
}
