/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:21:25 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys;

/**
 * Types are used to define return types of Primitives and Chromosomes.  They
 * are also used to define the argument types of Functions.  A type has a
 * string which defines the name of the type, name, and a unique integer which
 * is used to identify the type (the typeID).  This class has many predefined
 * Types which are implemented as constants of this class.
 * If a new type is required, make sure that a unique typeID is used.  Note
 * that to facilitate their use in java switch statements, Type constants for
 * the predefined types also have their typeIDs duplicately defined as integer
 * contants.
 *
 * @see gpsys.Primitive
 * @see gpsys.Function
 * @see gpsys.Chromosome
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:21:25 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class Type implements java.io.Serializable {

    /**
    * The typeID uniquely identifies the Type.
    */
    public int      typeID;
    /**
    * The name given to the type.
    */
    public String   typeName;

    // sorry about the typeID constants, they're needed for switch statements
    // alas if/else chains are just not efficient enough

    /**
    * The java byte type.
    */
    public static final Type BYTE           = new Type(0, "BYTE");
    /**
    * The type ID for java byte type.
    */
    public static final int  BYTE_typeID    = 0;

    /**
    * The java short type.
    */
    public static final Type SHORT          = new Type(1, "SHORT");
    /**
    * The type ID for java byte type.
    */
    public static final int  SHORT_typeID   = 1;

    /**
    * The java int type.
    */
    public static final Type INT            = new Type(2, "INT");
    /**
    * The type ID for java byte type.
    */
    public static final int  INT_typeID     = 2;

    /**
    * The java long type.
    */
    public static final Type LONG           = new Type(3, "LONG");
    /**
    * The type ID for java byte type.
    */
    public static final int  LONG_typeID    = 3;

    /**
    * The java float type.
    */
    public static final Type FLOAT          = new Type(4, "FLOAT");
    /**
    * The type ID for java byte type.
    */
    public static final int  FLOAT_typeID   = 4;

    /**
    * The java double type.
    */
    public static final Type DOUBLE         = new Type(5, "DOUBLE");
    /**
    * The type ID for java byte type.
    */
    public static final int  DOUBLE_typeID  = 5;

    /**
    * The java char type.
    */
    public static final Type CHAR           = new Type(6, "CHAR");
    /**
    * The type ID for java byte type.
    */
    public static final int  CHAR_typeID    = 6;

    /**
    * The java boolean type.
    */
    public static final Type BOOLEAN        = new Type(7, "BOOLEAN");
    /**
    * The type ID for java byte type.
    */
    public static final int  BOOLEAN_typeID = 7;

    /**
    * The a reference to the java Object type.
    */
    public static final Type OBJECT         = new Type(8, "OBJECT");
    /**
    * The type ID for java byte type.
    */
    public static final int  OBJECT_typeID  = 8;

    /**
    * Indexed memory of java byte type.
    */
    public static final Type MEM_BYTE           = new Type( 9, "MEM_BYTE");
    /**
    * The type ID for java byte type.
    */
    public static final int  MEM_BYTE_typeID    = 9;

    /**
    * Indexed memory of java short type.
    */
    public static final Type MEM_SHORT          = new Type(10, "MEM_SHORT");
    /**
    * The type ID for java byte type.
    */
    public static final int  MEM_SHORT_typeID   = 10;

    /**
    * Indexed memory of java int type.
    */
    public static final Type MEM_INT            = new Type(11, "MEM_INT");
    /**
    * The type ID for java byte type.
    */
    public static final int  MEM_INT_typeID     = 11;

    /**
    * Indexed memory of java long type.
    */
    public static final Type MEM_LONG           = new Type(12, "MEM_LONG");
    /**
    * The type ID for java byte type.
    */
    public static final int  MEM_LONG_typeID    = 12;

    /**
    * Indexed memory of java float type.
    */
    public static final Type MEM_FLOAT          = new Type(13, "MEM_FLOAT");
    /**
    * The type ID for java byte type.
    */
    public static final int  MEM_FLOAT_typeID   = 13;

    /**
    * Indexed memory of java double type.
    */
    public static final Type MEM_DOUBLE         = new Type(14, "MEM_DOUBLE");
    /**
    * The type ID for java byte type.
    */
    public static final int  MEM_DOUBLE_typeID  = 14;

    /**
    * Indexed memory of java char type.
    */
    public static final Type MEM_CHAR           = new Type(15, "MEM_CHAR");
    /**
    * The type ID for java byte type.
    */
    public static final int  MEM_CHAR_typeID    = 15;

    /**
    * Indexed memory of java boolean type.
    */
    public static final Type MEM_BOOLEAN        = new Type(16, "MEM_BOOLEAN");
    /**
    * The type ID for java byte type.
    */
    public static final int  MEM_BOOLEAN_typeID = 16;

    /**
    * Indexed memory of references to java Object types.
    */
    public static final Type MEM_OBJECT         = new Type(17, "MEM_OBJECT");
    /**
    * The type ID for java byte type.
    */
    public static final int  MEM_OBJECT_typeID  = 17;

    /**
    * Default constructor, should never be used.
    */
    public Type() {
        typeID      = -1;
        typeName    = "No Type";
    }

    /**
    * Construct a new type with the specified typeID and name.
    *
    * @param    typeID      A unique integer indentifying the type.
    * @param    typeName    Your name for the type.
    */
    public Type(int typeID, String typeName) {
        this.typeID     = typeID;
        this.typeName   = typeName;
    }

    /**
    * Get a string representation of the type (the name of the type).
    *
    * @return   The name of the type.
    */
    public String toString() {
        return typeName;
    }
}
