/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:21:25 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys;

/**
 * The super class of all GP Terminals.  A Terminal is a primitive that take no
 * arguments.  This abstract class should be extended to create your own
 * Terminals.  One or more of the evaulation methods should be overridden to
 * create the desired value.  The reason the evaulation methods have not been
 * declared abstract is to relieve the burden of subclasses having to define
 * all of the different evaluation methods, when only one is needed.
 *
 * @see         gpsys.Primitive
 * @see         gpsys.primitive
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:21:25 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public abstract class Terminal extends Primitive {

    /**
     * To be overridden by Terminals returning an Object when evaluated.
     *
     * @param   i   the individual that is being evaluated.
     * @return  A reference to an Object which is the evaluation result.
     * @exception   EvaluationException If this method is called.
     */
    public Object   evaluateObject(Individual i)
    throws EvaluationException {
        throw new MissingEvaluatorException(
            "evaluateObject() of abstract class Terminal invoked");
    }

    /**
     * To be overridden by Terminals returning a byte when evaluated.
     *
     * @param   i   the individual that is being evaluated.
     * @return  A byte which is the evaluation result.
     * @exception   EvaluationException If this method is called.
     */
    public byte     evaluateByte(Individual i)
    throws EvaluationException {
        throw new MissingEvaluatorException(
            "evaluateByte() of abstract class Terminal invoked");
    }

    /**
     * To be overridden by Terminals returning a short when evaluated.
     *
     * @param   i   the individual that is being evaluated.
     * @return  A short which is the evaluation result.
     * @exception   EvaluationException If this method is called.
     */
    public short    evaluateShort(Individual i)
    throws EvaluationException {
        throw new MissingEvaluatorException(
            "evaluateShort() of abstract class Terminal invoked");
    }

    /**
     * To be overridden by Terminals returning an int when evaluated.
     *
     * @param   i   the individual that is being evaluated.
     * @return  An int which is the evaluation result.
     * @exception   EvaluationException If this method is called.
     */
    public int      evaluateInt(Individual i)
    throws EvaluationException {
        throw new MissingEvaluatorException(
            "evaluateInt() of abstract class Terminal invoked");
    }

    /**
     * To be overridden by Terminals returning a long when evaluated.
     *
     * @param   i   the individual that is being evaluated.
     * @return  A long which is the evaluation result.
     * @exception   EvaluationException If this method is called.
     */
    public long     evaluateLong(Individual i)
    throws EvaluationException {
        throw new MissingEvaluatorException(
            "evaluateLong() of abstract class Terminal invoked");
    }

    /**
     * To be overridden by Terminals returning a float when evaluated.
     *
     * @param   i   the individual that is being evaluated.
     * @return  A float which is the evaluation result.
     * @exception   EvaluationException If this method is called.
     */
    public float    evaluateFloat(Individual i)
    throws EvaluationException {
        throw new MissingEvaluatorException(
            "evaluateFloat() of abstract class Terminal invoked");
    }

    /**
     * To be overridden by Terminals returning a double when evaluated.
     *
     * @param   i   the individual that is being evaluated.
     * @return  A double which is the evaluation result.
     * @exception   EvaluationException If this method is called.
     */
    public double   evaluateDouble(Individual i)
    throws EvaluationException {
        throw new MissingEvaluatorException(
            "evaluateDouble() of abstract class Terminal invoked");
    }

    /**
     * To be overridden by Terminals returning a char when evaluated.
     *
     * @param   i   the individual that is being evaluated.
     * @return  A char which is the evaluation result.
     * @exception   EvaluationException If this method is called.
     */
    public char     evaluateChar(Individual i)
    throws EvaluationException {
        throw new MissingEvaluatorException(
            "evaluateChar() of abstract class Terminal invoked");
    }

    /**
     * To be overridden by Terminals returning a boolean when evaluated.
     *
     * @param   i   the individual that is being evaluated.
     * @return  A boolean which is the evaluation result.
     * @exception   EvaluationException If this method is called.
     */
    public boolean  evaluateBoolean(Individual i)
    throws EvaluationException {
        throw new MissingEvaluatorException(
            "evaluateBoolean() of abstract class Terminal invoked");
    }
}
