/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:21:25 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys;

/**
 * A Primitive is unit of an evolved program.  Users should never try to
 * extend this class directly to create their own primitives.  Instead they
 * should extend the derived classes Function, Terminal, ADFunction or
 * ADTerminal.
 *
 * @see         gpsys.Terminal
 * @see         gpsys.Function
 * @see         gpsys.ADTerminal
 * @see         gpsys.ADFunction
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:21:25 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public abstract class Primitive implements java.io.Serializable {
    /**
     * The type returned by this primitive.
     */
    public Type type;   // type returned by evaluation

    /**
     * Creates a new instance of this primitive.
     *
     * @return  returns a new instance of this primitive.
     */
    public abstract Primitive   instance();

    /**
     * Creates a String representation of this primitive. 
     *
     * @return The String representation of this primitive.
     */
    public abstract String      toString();
}
