/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:21:25 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys;

/**
 * An MissingEvaluatorException is generated when an evaluate method of the
 * class Function or Terminal has been invoked.  The classes Function and
 * Terminal are abstract and hence should never have their evaluation methods
 * called.  This can happen if evaluation method being invoked has not been
 * definde in a Function or Terminal subclass.
 *
 * @see gpsys.EvaluationException
 * @see gpsys.Terminal
 * @see gpsys.Function
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:21:25 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class MissingEvaluatorException extends EvaluationException {
    /**
     * Create an MissingEvaluatorException with an empty message.
     */
    public MissingEvaluatorException() {
        super();
    }

    /**
     * Create an MissingEvaluatorException with the specified message.
     *
     * @param   message     a message describing the the exception.
     */
    public MissingEvaluatorException(String message) {
        super(message);
    }
}
