/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:21:25 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys;

/**
 * A GeneFunctionFull is a GeneFunction tree created using the Full method.
 * In the Full method, the tree is full depth along any path from the root
 * to a leaf.
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:21:25 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class GeneFunctionFull extends GeneFunction implements Cloneable {
    /**
     * Create a Gene tree using the Full method.  The Full method tries
     * to create trees of the maximum specified depth along any branch.
     *
     * @param   maxDepth    the maximum depth of the Gene tree to be generated.
     * @param   type        the required return type of top node in the tree.
     * @param   gpParameters    the GP parameters for this run.
     * @param   adfIndex    the index of the ChromosomeParameters to used.
     * @exception   TypeException   If a Function or Terminal of a required
     *                              type could not be found.
     *
     */
    public GeneFunctionFull(int maxDepth, Type type,
        GPParameters gpParameters, int adfIndex) throws TypeException {

        // get an array of all functions of the required type
        Function[] functionsOfType =
            gpParameters.adf[adfIndex].functionsOfTypeAtDepthFull[maxDepth].
                get(type);
        
        if (functionsOfType == null)
            throw new TypeException(
                "no function of type " + type.toString() +
                " at depth " + maxDepth);

        // then select a function at random from this array and assign to p
        int code =  gpParameters.rng.nextInt() % functionsOfType.length;
        code = (code < 0) ? -code : code;
        Function f = (Function) functionsOfType[code].instance();
        p = f;

        // now generate the arguments to this function
        arguments = new Gene[f.argTypes.length];
        maxDepth--;
        for (int i = 0; i < arguments.length; i++)
            if (maxDepth > 0) { // if there is depth make another GeneFunction
                try {
                    arguments[i] = new
                        GeneFunctionFull(maxDepth, f.argTypes[i],
                            gpParameters, adfIndex);
                }
                catch (TypeException e) {
                    gpParameters.observer.diagnosticUpdate(
                        "GeneFunctionFull " + e.getMessage());
                    arguments[i] = new
                        GeneTerminal(maxDepth, f.argTypes[i],
                            gpParameters, adfIndex);
                }
            }
            else                // else make a GeneTerminal
                arguments[i] = new
                    GeneTerminal(maxDepth, f.argTypes[i],
                        gpParameters, adfIndex);
    }
}
