/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:21:25 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys;

/**
 * A Gene is a node in a GP tree.  A Gene can be either a function or a
 * terminal, hence this abstract class has been subclassed to GeneFunction and
 * GeneTerminal which are actually used.
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:21:25 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public abstract class Gene implements java.io.Serializable {
    /**
     * The primitive associated with this Gene which is either a Function or a
     * Terminal.
     */
    public Primitive p;

    /**
     * Calculates the number of nodes (Genes) in the subtree starting at this
     * node (Gene).
     */
    abstract public int     complexity();

    /**
     * Calculates the maximum depth of the subtree starting at this node (Gene).
     */
    abstract public int     depth();

    /**
     * Evaluate this Gene as a Gene that returns an Object when evaluated.
     *
     * @param   i   the Individual being evaluated.
     * @return  An Object which is the evaluation result.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public abstract Object  evaluateObject(Individual i)
        throws EvaluationException;

    /**
     * Evaluate this Gene as a Gene that returns a byte when evaluated.
     *
     * @param   i   the Individual being evaluated.
     * @return  A byte which is the evaluation result.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public abstract byte    evaluateByte(Individual i)
        throws EvaluationException;

    /**
     * Evaluate this Gene as a Gene that returns a short when evaluated.
     *
     * @param   i   the Individual being evaluated.
     * @return  A short which is the evaluation result.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public abstract short   evaluateShort(Individual i)
        throws EvaluationException;

    /**
     * Evaluate this Gene as a Gene that returns a int when evaluated.
     *
     * @param   i   the Individual being evaluated.
     * @return  A int which is the evaluation result.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public abstract int     evaluateInt(Individual i)
        throws EvaluationException;

    /**
     * Evaluate this Gene as a Gene that returns a long when evaluated.
     *
     * @param   i   the Individual being evaluated.
     * @return  A long which is the evaluation result.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public abstract long    evaluateLong(Individual i)
        throws EvaluationException;

    /**
     * Evaluate this Gene as a Gene that returns a float when evaluated.
     *
     * @param   i   the Individual being evaluated.
     * @return  A float which is the evaluation result.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public abstract float   evaluateFloat(Individual i)
        throws EvaluationException;

    /**
     * Evaluate this Gene as a Gene that returns a double when evaluated.
     *
     * @param   i   the Individual being evaluated.
     * @return  A double which is the evaluation result.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public abstract double  evaluateDouble(Individual i)
        throws EvaluationException;

    /**
     * Evaluate this Gene as a Gene that returns a char when evaluated.
     *
     * @param   i   the Individual being evaluated.
     * @return  A char which is the evaluation result.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public abstract char    evaluateChar(Individual i)
        throws EvaluationException;

    /**
     * Evaluate this Gene as a Gene that returns a boolean when evaluated.
     *
     * @param   i   the Individual being evaluated.
     * @return  A boolean which is the evaluation result.
     * @exception   EvaluationException If there is an evaluation failure.
     */
    public abstract boolean evaluateBoolean(Individual i)
        throws EvaluationException;

    /**
     * Makes a deep clone of this Gene, i.e. the Gene and all of it's subtrees.
     *
     * @return  A clone of the Gene and its subtrees.
     */
    abstract public Gene    deepClone();

    /**
     * Converts the Gene and its subtrees into a String.
     *
     * @return  A String representing the Gene and any subtrees.
     */
    abstract public String  toString();
}
