/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:21:25 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys;

import java.util.Random;
import java.io.*;

/**
 * The top level class of the GP system.  Construct an object of this type
 * by supplying the GPParameters, and then call the evolve method to evolve
 * the code.  Evolution is halted when a solution that meets the termination
 * citeria is met or when the population has evolved to the required number of
 * generations.
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:21:25 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class GPsys {

    /**
     * The GPParameters defining the problem.
     */
    GPParameters    gpParameters;

    /**
     * Construct a GP system using the supplied GPParameters object.
     * if the population field of the gpParameters object is null, then
     * a new initial population is created.
     *
     * @param   gpParameters    The GPParaemeters defining the problem.
     */
    public GPsys(GPParameters gpParameters) {

        this.gpParameters = gpParameters;

        // if the population is empty create a new population
        if (gpParameters.population == null) {
            gpParameters.observer.diagnosticUpdate(
                "Creating initial population...");
            // for each ADF initialise the type possibilities tables
            for (int i = 0; i < gpParameters.adf.length; i++)
                gpParameters.adf[i].initialiseTypeTables(
                    gpParameters.adf[i].maxDepthAtCreation);
            // create the new population and let the user know
            gpParameters.population = new Population(gpParameters);
            gpParameters.observer.diagnosticUpdate(
                "Initial population created.");
            gpParameters.observer.generationUpdate(gpParameters,
                GPObserver.CREATION);
        } else  // must have been loaded from a stream or file
            gpParameters.observer.generationUpdate(gpParameters,
                GPObserver.FROMSTREAM);

    }

    /**
     * Evolves the population until the required number of generations have
     * been produced or the termination criteria has been satisfied.
     */
    public void evolve() {
        gpParameters.observer.diagnosticUpdate("Evolving...");
        while (gpParameters.population.generation <
            gpParameters.generations) {
            gpParameters.population.evolve();
            gpParameters.observer.generationUpdate(gpParameters,
                GPObserver.EVOLVED);
        //  if (gpParameters.population.best.fitness.terminationCondition())
        //      break;
        }
        gpParameters.observer.diagnosticUpdate("GP run completed.");
    }
}
