/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:21:25 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys;

/**
 * Classes that implement this interface can become observers of the GP system.
 * By defining the functions of this interface they can monitor important
 * events such as the creation of new Individuals and the completion of a
 * generation.  
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:21:25 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public interface GPObserver {
    /**
     * Used to indicate that an Individual was created via mutation.
     */
    public static final int VIA_MUTATION    = 0;

    /**
     * Used to indicate that an Individual was created via crossover.
     */
    public static final int VIA_CROSSOVER   = 1;

    /**
     * Used to indicate that an Individual was created via reproduction.
     */
    public static final int VIA_REPRODUCTION    = 2;

    /**
     * Used to indicate that an Individual was created via creation.
     */
    public static final int VIA_CREATION    = 3;

    /**
     * Used to indicate that the generation update is for the 0th generation.
     */
    public static final int CREATION    = 0;

    /**
     * Used to indicate that the generation update represents a generation
     * loaded from a stream.
     */
    public static final int FROMSTREAM  = 1;

    /**
     * Used to indicate that the generation update represents a generation
     * that has been evolved.
     */
    public static final int EVOLVED     = 2;

    /**
     * Invoked by the GP system whenever a new generation has been created.
     *
     * @param   gpParameters    the GP parameters used for this run.
     * @param   how             how the generation was created.  Can be either
     *                          CREATION, FROMSTREAM or EVOLVED.
     */
    public void generationUpdate(GPParameters gpParameters, int how);

    /**
     * Invoked by the GP system whenever a new Individual has been created.
     *
     * @param   gpParameters    the GP parameters used for this run.
     * @param   i               the Individual that has just been created.
     * @param   creationMethod  how the Individual was created.  Can be either
     *                          VIA_CREATION, VIA_REPRODUCTION, VIA_MUTATION or
     *                          VIA_CROSSOVER.
     */
    public void individualUpdate(GPParameters gpParameters,
        Individual i, int creationMethod);

    /**
     * Invoked by the GP system whenever something interesting occurs, the
     * supplied String indictates what happened.
     *
     * @param   s   a String describing the event.
     */
    public void diagnosticUpdate(String s);

    /**
     * Invoked by the GP system whenever an exception occurs, override this
     * to do something useful such as print a stack trace.
     *
     * @param   e   The Exception that was raised.
     */
    public void exception(GPException e);
}
