/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:21:25 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys;

/**
 * Represents the fitness of an individual.  This class must be
 * subclassed to define the fitness measure for your application.
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:21:25 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public abstract class Fitness implements java.io.Serializable {

    /**
     * Add a fitness value to this fitness value.
     *
     * @param   f   the fitness value to be added.
     */
    public abstract void add(Fitness f);

    /**
     * Divide the fitness by the specified integer.  This is used by the
     * GP system to calculate the average fitness of the population.
     *
     * @param   divisor the integer to divide the fitness by.
     */
    public abstract void divide(int divisor);

    /**
     * Tests if this fitness is equal to another fitness.
     *
     * @param   f   the fitness with which to compare.
     * @return  true if f has the same fitness, false otherwise.
     */
    public abstract boolean equals(Fitness f);

    /**
     * Tests if this fitness is less than another fitness.
     *
     * @param   f   the fitness with which to compare.
     * @return  true if f has less fitness, false otherwise.
     */
    public abstract boolean lessThan(Fitness f);

    /**
     * Tests if this fitness value is greater than another fitness value.
     *
     * @param   f   the fitness with which to compare.
     * @return  true if f has higher fitness, false otherwise.
     */
    public abstract boolean greaterThan(Fitness f);

    /**
     * Creates a new instance of the Fitness object with a default fitness.
     *
     * @return  an instance of a Fitness object with default fitness.
     */
    public abstract Fitness instance();

    /**
     * Creates a new instance of the Fitness object which represents the
     * fitness of the specified individual.
     *
     * @param   gpParameters    the parameters for this GP run.
     * @param   i               the individual to be evaluated.
     * @return  The Fitness of the specified individual.
     */
    public abstract Fitness instance(GPParameters gpParameters, Individual i);

    /**
     * Tests whether this fitness meets the termination criteria.
     *
     * @return  true if the termination criteria has been met, false otherwise.
     */
    public abstract boolean terminationCondition();

    /**
     * Converts the fitness into a String suitable for printing.
     *
     * @return  A String representing the fitness.
     */
    public abstract String toString();
}
