/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:21:25 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys;

/**
 * The root of all evaluation exceptions.  This class should be subclassed to
 * create exceptions that can be generated by functions por terminals during
 * evalution.
 *
 * @see gpsys.DivideByZeroException
 * @see gpsys.MissingEvaluatorException
 * @see gpsys.GPException
 * @see gpsys.Terminal
 * @see gpsys.Function
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:21:25 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class EvaluationException extends GPException {
    /**
     * Create an EvaluationException with an empty message.
     */
    public EvaluationException() {
        super();
    }

    /**
     * Create an EvaluationException with the specified message.
     *
     * @param   message     a message describing the the exception.
     */
    public EvaluationException(String message) {
        super(message);
    }
}
