/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:21:25 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys;

/**
 * An DivideByZeroException flags an attempt to divide by zero.
 *
 * @see gpsys.GPDivideByZeroException
 * @see gpsys.EvaluationException
 * @see gpsys.primitives.Div
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:21:25 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
public class DivideByZeroException extends EvaluationException {
    /**
     * Create a DivideByZeroException with an empty message.
     */
    public DivideByZeroException() {
        super();
    }

    /**
     * Create a DivideByZeroException with the specified message.
     *
     * @param   message     a message describing the the exception.
     */
    public DivideByZeroException(String message) {
        super(message);
    }
}
