/*
    Copyright Adil Qureshi - $Date: 2000/07/05 16:21:25 $
    This code is part of gpsys Release $Name: 2b $
    and is released for non-commercial use only.
    Questions, comments etc should be forwarded to :-

        Adil Qureshi
        University College London,
        Department of Computer Science,
        Gower St,
        London WC1E 6BT, UK.
        email: A.Qureshi@cs.ucl.ac.uk
        URL : http://www.cs.ucl.ac.uk/staff/A.Qureshi/
*/

package gpsys;

/**
 * This class represents a Crossover operation.  A Crossover operation involves
 * just two parents, which are specified in the constructor.
 *
 * @see gpsys.CrossoverBookkeeping
 * @see gpsys.Population
 * @see gpsys.GPParameters
 *
 * @version     $Revision: 1.1 $, $Date: 2000/07/05 16:21:25 $
 * @author  <a href="mailto:A.Qureshi@cs.ucl.ac.uk">Adil Qureshi</a>
 *          <address>Department of Computer Science,</address>
 *          <address>University College London,</address>
 *          <address>Gower St,</address>
 *          <address>London WC1E 6BT,</address>
 *          <address>UK.</address>
 */
class CrossoverOperation extends GeneticOperation {
    /**
     * The second parent involved in the crossover.
     */
    int parent2;
    
    /**
     * Constructs a Crossover operation to be performed on the specified parents.
     *
     * @param parent1   The first parent involved in the crossover.
     * @param parent2   The second parent involved in the crossover.
     */ 
    public CrossoverOperation(int parent1, int parent2) {
        this.parent1 = parent1;
        this.parent2 = parent2;
    }
}

